package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPermissionsRequest(
    resourceType: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListPermissionsRequest = {
    import ListPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListPermissionsRequest
      .builder()
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ListPermissionsRequest.ReadOnly =
    zio.aws.ram.model.ListPermissionsRequest.wrap(buildAwsValue())
}
object ListPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListPermissionsRequest =
      zio.aws.ram.model.ListPermissionsRequest(
        resourceType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceType: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListPermissionsRequest
  ) extends zio.aws.ram.model.ListPermissionsRequest.ReadOnly {
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListPermissionsRequest
  ): zio.aws.ram.model.ListPermissionsRequest.ReadOnly = new Wrapper(impl)
}
