package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPermissionsResponse(
    permissions: Optional[
      Iterable[zio.aws.ram.model.ResourceSharePermissionSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListPermissionsResponse = {
    import ListPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListPermissionsResponse
      .builder()
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ListPermissionsResponse.ReadOnly =
    zio.aws.ram.model.ListPermissionsResponse.wrap(buildAwsValue())
}
object ListPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListPermissionsResponse =
      zio.aws.ram.model.ListPermissionsResponse(
        permissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def permissions: Optional[
      List[zio.aws.ram.model.ResourceSharePermissionSummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getPermissions: ZIO[Any, AwsError, List[
      zio.aws.ram.model.ResourceSharePermissionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("permissions", permissions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListPermissionsResponse
  ) extends zio.aws.ram.model.ListPermissionsResponse.ReadOnly {
    override val permissions: Optional[
      List[zio.aws.ram.model.ResourceSharePermissionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ram.model.ResourceSharePermissionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListPermissionsResponse
  ): zio.aws.ram.model.ListPermissionsResponse.ReadOnly = new Wrapper(impl)
}
