package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPrincipalsRequest(
    resourceOwner: zio.aws.ram.model.ResourceOwner,
    resourceArn: Optional[String] = Optional.Absent,
    principals: Optional[Iterable[String]] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent,
    resourceShareArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListPrincipalsRequest = {
    import ListPrincipalsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListPrincipalsRequest
      .builder()
      .resourceOwner(resourceOwner.unwrap)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(
        resourceShareArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceShareArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ListPrincipalsRequest.ReadOnly =
    zio.aws.ram.model.ListPrincipalsRequest.wrap(buildAwsValue())
}
object ListPrincipalsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListPrincipalsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListPrincipalsRequest =
      zio.aws.ram.model.ListPrincipalsRequest(
        resourceOwner,
        resourceArn.map(value => value),
        principals.map(value => value),
        resourceType.map(value => value),
        resourceShareArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceOwner: zio.aws.ram.model.ResourceOwner
    def resourceArn: Optional[String]
    def principals: Optional[List[String]]
    def resourceType: Optional[String]
    def resourceShareArns: Optional[List[String]]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getResourceOwner: ZIO[Any, Nothing, zio.aws.ram.model.ResourceOwner] =
      ZIO.succeed(resourceOwner)
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getPrincipals: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("principals", principals)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceShareArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceShareArns", resourceShareArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListPrincipalsRequest
  ) extends zio.aws.ram.model.ListPrincipalsRequest.ReadOnly {
    override val resourceOwner: zio.aws.ram.model.ResourceOwner =
      zio.aws.ram.model.ResourceOwner.wrap(impl.resourceOwner())
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
    override val principals: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.principals())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val resourceShareArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListPrincipalsRequest
  ): zio.aws.ram.model.ListPrincipalsRequest.ReadOnly = new Wrapper(impl)
}
