package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPrincipalsResponse(
    principals: Optional[Iterable[zio.aws.ram.model.Principal]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListPrincipalsResponse = {
    import ListPrincipalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListPrincipalsResponse
      .builder()
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ListPrincipalsResponse.ReadOnly =
    zio.aws.ram.model.ListPrincipalsResponse.wrap(buildAwsValue())
}
object ListPrincipalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListPrincipalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListPrincipalsResponse =
      zio.aws.ram.model.ListPrincipalsResponse(
        principals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def principals: Optional[List[zio.aws.ram.model.Principal.ReadOnly]]
    def nextToken: Optional[String]
    def getPrincipals
        : ZIO[Any, AwsError, List[zio.aws.ram.model.Principal.ReadOnly]] =
      AwsError.unwrapOptionField("principals", principals)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListPrincipalsResponse
  ) extends zio.aws.ram.model.ListPrincipalsResponse.ReadOnly {
    override val principals
        : Optional[List[zio.aws.ram.model.Principal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.Principal.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListPrincipalsResponse
  ): zio.aws.ram.model.ListPrincipalsResponse.ReadOnly = new Wrapper(impl)
}
