package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResourceSharePermissionsRequest(
    resourceShareArn: String,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest = {
    import ListResourceSharePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.ListResourceSharePermissionsRequest.ReadOnly =
    zio.aws.ram.model.ListResourceSharePermissionsRequest.wrap(buildAwsValue())
}
object ListResourceSharePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListResourceSharePermissionsRequest =
      zio.aws.ram.model.ListResourceSharePermissionsRequest(
        resourceShareArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceShareArn: String
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest
  ) extends zio.aws.ram.model.ListResourceSharePermissionsRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest
  ): zio.aws.ram.model.ListResourceSharePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
