package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListResourceTypesResponse(
    resourceTypes: Optional[
      Iterable[zio.aws.ram.model.ServiceNameAndResourceType]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListResourceTypesResponse = {
    import ListResourceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListResourceTypesResponse
      .builder()
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ListResourceTypesResponse.ReadOnly =
    zio.aws.ram.model.ListResourceTypesResponse.wrap(buildAwsValue())
}
object ListResourceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListResourceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListResourceTypesResponse =
      zio.aws.ram.model.ListResourceTypesResponse(
        resourceTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceTypes
        : Optional[List[zio.aws.ram.model.ServiceNameAndResourceType.ReadOnly]]
    def nextToken: Optional[String]
    def getResourceTypes: ZIO[Any, AwsError, List[
      zio.aws.ram.model.ServiceNameAndResourceType.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListResourceTypesResponse
  ) extends zio.aws.ram.model.ListResourceTypesResponse.ReadOnly {
    override val resourceTypes: Optional[
      List[zio.aws.ram.model.ServiceNameAndResourceType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ram.model.ServiceNameAndResourceType.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListResourceTypesResponse
  ): zio.aws.ram.model.ListResourceTypesResponse.ReadOnly = new Wrapper(impl)
}
