package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResourcesRequest(
    resourceOwner: zio.aws.ram.model.ResourceOwner,
    principal: Optional[String] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent,
    resourceArns: Optional[Iterable[String]] = Optional.Absent,
    resourceShareArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    resourceRegionScope: Optional[zio.aws.ram.model.ResourceRegionScopeFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListResourcesRequest = {
    import ListResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListResourcesRequest
      .builder()
      .resourceOwner(resourceOwner.unwrap)
      .optionallyWith(principal.map(value => value: java.lang.String))(
        _.principal
      )
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .optionallyWith(
        resourceShareArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceShareArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(resourceRegionScope.map(value => value.unwrap))(
        _.resourceRegionScope
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ListResourcesRequest.ReadOnly =
    zio.aws.ram.model.ListResourcesRequest.wrap(buildAwsValue())
}
object ListResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListResourcesRequest =
      zio.aws.ram.model.ListResourcesRequest(
        resourceOwner,
        principal.map(value => value),
        resourceType.map(value => value),
        resourceArns.map(value => value),
        resourceShareArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceRegionScope.map(value => value)
      )
    def resourceOwner: zio.aws.ram.model.ResourceOwner
    def principal: Optional[String]
    def resourceType: Optional[String]
    def resourceArns: Optional[List[String]]
    def resourceShareArns: Optional[List[String]]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def resourceRegionScope
        : Optional[zio.aws.ram.model.ResourceRegionScopeFilter]
    def getResourceOwner: ZIO[Any, Nothing, zio.aws.ram.model.ResourceOwner] =
      ZIO.succeed(resourceOwner)
    def getPrincipal: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principal", principal)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
    def getResourceShareArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceShareArns", resourceShareArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceRegionScope
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceRegionScopeFilter] =
      AwsError.unwrapOptionField("resourceRegionScope", resourceRegionScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListResourcesRequest
  ) extends zio.aws.ram.model.ListResourcesRequest.ReadOnly {
    override val resourceOwner: zio.aws.ram.model.ResourceOwner =
      zio.aws.ram.model.ResourceOwner.wrap(impl.resourceOwner())
    override val principal: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => value: String)
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val resourceArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val resourceShareArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
    override val resourceRegionScope
        : Optional[zio.aws.ram.model.ResourceRegionScopeFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRegionScope())
        .map(value => zio.aws.ram.model.ResourceRegionScopeFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListResourcesRequest
  ): zio.aws.ram.model.ListResourcesRequest.ReadOnly = new Wrapper(impl)
}
