package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListResourcesResponse(
    resources: Optional[Iterable[zio.aws.ram.model.Resource]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListResourcesResponse = {
    import ListResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListResourcesResponse
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ListResourcesResponse.ReadOnly =
    zio.aws.ram.model.ListResourcesResponse.wrap(buildAwsValue())
}
object ListResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListResourcesResponse =
      zio.aws.ram.model.ListResourcesResponse(
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resources: Optional[List[zio.aws.ram.model.Resource.ReadOnly]]
    def nextToken: Optional[String]
    def getResources
        : ZIO[Any, AwsError, List[zio.aws.ram.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("resources", resources)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListResourcesResponse
  ) extends zio.aws.ram.model.ListResourcesResponse.ReadOnly {
    override val resources
        : Optional[List[zio.aws.ram.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.Resource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListResourcesResponse
  ): zio.aws.ram.model.ListResourcesResponse.ReadOnly = new Wrapper(impl)
}
