package zio.aws.ram.model
import zio.aws.ram.model.primitives.DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Principal(
    id: Optional[String] = Optional.Absent,
    resourceShareArn: Optional[String] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    lastUpdatedTime: Optional[DateTime] = Optional.Absent,
    external: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ram.model.Principal = {
    import Principal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.Principal
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(resourceShareArn.map(value => value: java.lang.String))(
        _.resourceShareArn
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(external.map(value => value: java.lang.Boolean))(
        _.external
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.Principal.ReadOnly =
    zio.aws.ram.model.Principal.wrap(buildAwsValue())
}
object Principal {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ram.model.Principal] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.Principal = zio.aws.ram.model.Principal(
      id.map(value => value),
      resourceShareArn.map(value => value),
      creationTime.map(value => value),
      lastUpdatedTime.map(value => value),
      external.map(value => value)
    )
    def id: Optional[String]
    def resourceShareArn: Optional[String]
    def creationTime: Optional[DateTime]
    def lastUpdatedTime: Optional[DateTime]
    def external: Optional[Boolean]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getResourceShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceShareArn", resourceShareArn)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getExternal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("external", external)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.Principal
  ) extends zio.aws.ram.model.Principal.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val resourceShareArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceShareArn())
      .map(value => value: String)
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val lastUpdatedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val external: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.external())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.Principal
  ): zio.aws.ram.model.Principal.ReadOnly = new Wrapper(impl)
}
