package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PromoteResourceShareCreatedFromPolicyResponse(
    returnValue: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse = {
    import PromoteResourceShareCreatedFromPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly =
    zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse
      .wrap(buildAwsValue())
}
object PromoteResourceShareCreatedFromPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse =
      zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse(
        returnValue.map(value => value)
      )
    def returnValue: Optional[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse
  ) extends zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse
  ): zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
