package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RejectResourceShareInvitationRequest(
    resourceShareInvitationArn: String,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest = {
    import RejectResourceShareInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest
      .builder()
      .resourceShareInvitationArn(resourceShareInvitationArn: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.RejectResourceShareInvitationRequest.ReadOnly =
    zio.aws.ram.model.RejectResourceShareInvitationRequest.wrap(buildAwsValue())
}
object RejectResourceShareInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.RejectResourceShareInvitationRequest =
      zio.aws.ram.model.RejectResourceShareInvitationRequest(
        resourceShareInvitationArn,
        clientToken.map(value => value)
      )
    def resourceShareInvitationArn: String
    def clientToken: Optional[String]
    def getResourceShareInvitationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareInvitationArn)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest
  ) extends zio.aws.ram.model.RejectResourceShareInvitationRequest.ReadOnly {
    override val resourceShareInvitationArn: String =
      impl.resourceShareInvitationArn(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest
  ): zio.aws.ram.model.RejectResourceShareInvitationRequest.ReadOnly =
    new Wrapper(impl)
}
