package zio.aws.ram.model
import zio.aws.ram.model.primitives.DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Resource(
    arn: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    resourceShareArn: Optional[String] = Optional.Absent,
    resourceGroupArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ram.model.ResourceStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    lastUpdatedTime: Optional[DateTime] = Optional.Absent,
    resourceRegionScope: Optional[zio.aws.ram.model.ResourceRegionScope] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ram.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.Resource
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(resourceShareArn.map(value => value: java.lang.String))(
        _.resourceShareArn
      )
      .optionallyWith(resourceGroupArn.map(value => value: java.lang.String))(
        _.resourceGroupArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(resourceRegionScope.map(value => value.unwrap))(
        _.resourceRegionScope
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.Resource.ReadOnly =
    zio.aws.ram.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ram.model.Resource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.Resource = zio.aws.ram.model.Resource(
      arn.map(value => value),
      `type`.map(value => value),
      resourceShareArn.map(value => value),
      resourceGroupArn.map(value => value),
      status.map(value => value),
      statusMessage.map(value => value),
      creationTime.map(value => value),
      lastUpdatedTime.map(value => value),
      resourceRegionScope.map(value => value)
    )
    def arn: Optional[String]
    def `type`: Optional[String]
    def resourceShareArn: Optional[String]
    def resourceGroupArn: Optional[String]
    def status: Optional[zio.aws.ram.model.ResourceStatus]
    def statusMessage: Optional[String]
    def creationTime: Optional[DateTime]
    def lastUpdatedTime: Optional[DateTime]
    def resourceRegionScope: Optional[zio.aws.ram.model.ResourceRegionScope]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getResourceShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceShareArn", resourceShareArn)
    def getResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceGroupArn", resourceGroupArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.ram.model.ResourceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getResourceRegionScope
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceRegionScope] =
      AwsError.unwrapOptionField("resourceRegionScope", resourceRegionScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.Resource
  ) extends zio.aws.ram.model.Resource.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val resourceShareArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceShareArn())
      .map(value => value: String)
    override val resourceGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceGroupArn())
      .map(value => value: String)
    override val status: Optional[zio.aws.ram.model.ResourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ram.model.ResourceStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val lastUpdatedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val resourceRegionScope
        : Optional[zio.aws.ram.model.ResourceRegionScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRegionScope())
        .map(value => zio.aws.ram.model.ResourceRegionScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.Resource
  ): zio.aws.ram.model.Resource.ReadOnly = new Wrapper(impl)
}
