package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceOwner {
  def unwrap: software.amazon.awssdk.services.ram.model.ResourceOwner
}
object ResourceOwner {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceOwner
  ): zio.aws.ram.model.ResourceOwner = value match {
    case software.amazon.awssdk.services.ram.model.ResourceOwner.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceOwner.SELF =>
      val r = SELF
      r
    case software.amazon.awssdk.services.ram.model.ResourceOwner.OTHER_ACCOUNTS =>
      val r = `OTHER-ACCOUNTS`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ram.model.ResourceOwner {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceOwner =
      software.amazon.awssdk.services.ram.model.ResourceOwner.UNKNOWN_TO_SDK_VERSION
  }
  case object SELF extends zio.aws.ram.model.ResourceOwner {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceOwner =
      software.amazon.awssdk.services.ram.model.ResourceOwner.SELF
  }
  case object `OTHER-ACCOUNTS` extends zio.aws.ram.model.ResourceOwner {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceOwner =
      software.amazon.awssdk.services.ram.model.ResourceOwner.OTHER_ACCOUNTS
  }
}
