package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceRegionScope {
  def unwrap: software.amazon.awssdk.services.ram.model.ResourceRegionScope
}
object ResourceRegionScope {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceRegionScope
  ): zio.aws.ram.model.ResourceRegionScope = value match {
    case software.amazon.awssdk.services.ram.model.ResourceRegionScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceRegionScope.REGIONAL =>
      val r = REGIONAL
      r
    case software.amazon.awssdk.services.ram.model.ResourceRegionScope.GLOBAL =>
      val r = GLOBAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ram.model.ResourceRegionScope {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceRegionScope =
      software.amazon.awssdk.services.ram.model.ResourceRegionScope.UNKNOWN_TO_SDK_VERSION
  }
  case object REGIONAL extends zio.aws.ram.model.ResourceRegionScope {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceRegionScope =
      software.amazon.awssdk.services.ram.model.ResourceRegionScope.REGIONAL
  }
  case object GLOBAL extends zio.aws.ram.model.ResourceRegionScope {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceRegionScope =
      software.amazon.awssdk.services.ram.model.ResourceRegionScope.GLOBAL
  }
}
