package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceRegionScopeFilter {
  def unwrap
      : software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter
}
object ResourceRegionScopeFilter {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter
  ): zio.aws.ram.model.ResourceRegionScopeFilter = value match {
    case software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.REGIONAL =>
      val r = REGIONAL
      r
    case software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.GLOBAL =>
      val r = GLOBAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ram.model.ResourceRegionScopeFilter {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter =
      software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.ram.model.ResourceRegionScopeFilter {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter =
      software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.ALL
  }
  case object REGIONAL extends zio.aws.ram.model.ResourceRegionScopeFilter {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter =
      software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.REGIONAL
  }
  case object GLOBAL extends zio.aws.ram.model.ResourceRegionScopeFilter {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter =
      software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter.GLOBAL
  }
}
