package zio.aws.ram.model
import zio.aws.ram.model.primitives.DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ResourceShare(
    resourceShareArn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    owningAccountId: Optional[String] = Optional.Absent,
    allowExternalPrincipals: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.ram.model.ResourceShareStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ram.model.Tag]] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    lastUpdatedTime: Optional[DateTime] = Optional.Absent,
    featureSet: Optional[zio.aws.ram.model.ResourceShareFeatureSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ResourceShare = {
    import ResourceShare.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ResourceShare
      .builder()
      .optionallyWith(resourceShareArn.map(value => value: java.lang.String))(
        _.resourceShareArn
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(owningAccountId.map(value => value: java.lang.String))(
        _.owningAccountId
      )
      .optionallyWith(
        allowExternalPrincipals.map(value => value: java.lang.Boolean)
      )(_.allowExternalPrincipals)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(featureSet.map(value => value.unwrap))(_.featureSet)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ResourceShare.ReadOnly =
    zio.aws.ram.model.ResourceShare.wrap(buildAwsValue())
}
object ResourceShare {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ram.model.ResourceShare] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ResourceShare =
      zio.aws.ram.model.ResourceShare(
        resourceShareArn.map(value => value),
        name.map(value => value),
        owningAccountId.map(value => value),
        allowExternalPrincipals.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        featureSet.map(value => value)
      )
    def resourceShareArn: Optional[String]
    def name: Optional[String]
    def owningAccountId: Optional[String]
    def allowExternalPrincipals: Optional[Boolean]
    def status: Optional[zio.aws.ram.model.ResourceShareStatus]
    def statusMessage: Optional[String]
    def tags: Optional[List[zio.aws.ram.model.Tag.ReadOnly]]
    def creationTime: Optional[DateTime]
    def lastUpdatedTime: Optional[DateTime]
    def featureSet: Optional[zio.aws.ram.model.ResourceShareFeatureSet]
    def getResourceShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceShareArn", resourceShareArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getOwningAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owningAccountId", owningAccountId)
    def getAllowExternalPrincipals: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowExternalPrincipals", allowExternalPrincipals)
    def getStatus: ZIO[Any, AwsError, zio.aws.ram.model.ResourceShareStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ram.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getFeatureSet
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShareFeatureSet] =
      AwsError.unwrapOptionField("featureSet", featureSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ResourceShare
  ) extends zio.aws.ram.model.ResourceShare.ReadOnly {
    override val resourceShareArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceShareArn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val owningAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.owningAccountId())
      .map(value => value: String)
    override val allowExternalPrincipals: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowExternalPrincipals())
        .map(value => value: Boolean)
    override val status: Optional[zio.aws.ram.model.ResourceShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ram.model.ResourceShareStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ram.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.Tag.wrap(item)
          }.toList
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val lastUpdatedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val featureSet
        : Optional[zio.aws.ram.model.ResourceShareFeatureSet] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureSet())
        .map(value => zio.aws.ram.model.ResourceShareFeatureSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ResourceShare
  ): zio.aws.ram.model.ResourceShare.ReadOnly = new Wrapper(impl)
}
