package zio.aws.ram.model
import zio.aws.ram.model.primitives.DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ResourceShareAssociation(
    resourceShareArn: Optional[String] = Optional.Absent,
    resourceShareName: Optional[String] = Optional.Absent,
    associatedEntity: Optional[String] = Optional.Absent,
    associationType: Optional[zio.aws.ram.model.ResourceShareAssociationType] =
      Optional.Absent,
    status: Optional[zio.aws.ram.model.ResourceShareAssociationStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    lastUpdatedTime: Optional[DateTime] = Optional.Absent,
    external: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ResourceShareAssociation = {
    import ResourceShareAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ResourceShareAssociation
      .builder()
      .optionallyWith(resourceShareArn.map(value => value: java.lang.String))(
        _.resourceShareArn
      )
      .optionallyWith(resourceShareName.map(value => value: java.lang.String))(
        _.resourceShareName
      )
      .optionallyWith(associatedEntity.map(value => value: java.lang.String))(
        _.associatedEntity
      )
      .optionallyWith(associationType.map(value => value.unwrap))(
        _.associationType
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(external.map(value => value: java.lang.Boolean))(
        _.external
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ResourceShareAssociation.ReadOnly =
    zio.aws.ram.model.ResourceShareAssociation.wrap(buildAwsValue())
}
object ResourceShareAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ResourceShareAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ResourceShareAssociation =
      zio.aws.ram.model.ResourceShareAssociation(
        resourceShareArn.map(value => value),
        resourceShareName.map(value => value),
        associatedEntity.map(value => value),
        associationType.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        external.map(value => value)
      )
    def resourceShareArn: Optional[String]
    def resourceShareName: Optional[String]
    def associatedEntity: Optional[String]
    def associationType
        : Optional[zio.aws.ram.model.ResourceShareAssociationType]
    def status: Optional[zio.aws.ram.model.ResourceShareAssociationStatus]
    def statusMessage: Optional[String]
    def creationTime: Optional[DateTime]
    def lastUpdatedTime: Optional[DateTime]
    def external: Optional[Boolean]
    def getResourceShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceShareArn", resourceShareArn)
    def getResourceShareName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceShareName", resourceShareName)
    def getAssociatedEntity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associatedEntity", associatedEntity)
    def getAssociationType
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShareAssociationType] =
      AwsError.unwrapOptionField("associationType", associationType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShareAssociationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getExternal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("external", external)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ResourceShareAssociation
  ) extends zio.aws.ram.model.ResourceShareAssociation.ReadOnly {
    override val resourceShareArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceShareArn())
      .map(value => value: String)
    override val resourceShareName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceShareName())
      .map(value => value: String)
    override val associatedEntity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associatedEntity())
      .map(value => value: String)
    override val associationType
        : Optional[zio.aws.ram.model.ResourceShareAssociationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationType())
        .map(value =>
          zio.aws.ram.model.ResourceShareAssociationType.wrap(value)
        )
    override val status
        : Optional[zio.aws.ram.model.ResourceShareAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.ram.model.ResourceShareAssociationStatus.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val lastUpdatedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val external: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.external())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ResourceShareAssociation
  ): zio.aws.ram.model.ResourceShareAssociation.ReadOnly = new Wrapper(impl)
}
