package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceShareAssociationStatus {
  def unwrap
      : software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus
}
object ResourceShareAssociationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus
  ): zio.aws.ram.model.ResourceShareAssociationStatus = value match {
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.ASSOCIATING =>
      val r = ASSOCIATING
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.ASSOCIATED =>
      val r = ASSOCIATED
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.DISASSOCIATING =>
      val r = DISASSOCIATING
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.DISASSOCIATED =>
      val r = DISASSOCIATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ram.model.ResourceShareAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSOCIATING
      extends zio.aws.ram.model.ResourceShareAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.ASSOCIATING
  }
  case object ASSOCIATED
      extends zio.aws.ram.model.ResourceShareAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.ASSOCIATED
  }
  case object FAILED extends zio.aws.ram.model.ResourceShareAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.FAILED
  }
  case object DISASSOCIATING
      extends zio.aws.ram.model.ResourceShareAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.DISASSOCIATING
  }
  case object DISASSOCIATED
      extends zio.aws.ram.model.ResourceShareAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus.DISASSOCIATED
  }
}
