package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceShareAssociationType {
  def unwrap
      : software.amazon.awssdk.services.ram.model.ResourceShareAssociationType
}
object ResourceShareAssociationType {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceShareAssociationType
  ): zio.aws.ram.model.ResourceShareAssociationType = value match {
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationType.PRINCIPAL =>
      val r = PRINCIPAL
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareAssociationType.RESOURCE =>
      val r = RESOURCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ram.model.ResourceShareAssociationType {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationType =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationType.UNKNOWN_TO_SDK_VERSION
  }
  case object PRINCIPAL extends zio.aws.ram.model.ResourceShareAssociationType {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationType =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationType.PRINCIPAL
  }
  case object RESOURCE extends zio.aws.ram.model.ResourceShareAssociationType {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareAssociationType =
      software.amazon.awssdk.services.ram.model.ResourceShareAssociationType.RESOURCE
  }
}
