package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceShareFeatureSet {
  def unwrap: software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet
}
object ResourceShareFeatureSet {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet
  ): zio.aws.ram.model.ResourceShareFeatureSet = value match {
    case software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.CREATED_FROM_POLICY =>
      val r = CREATED_FROM_POLICY
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.PROMOTING_TO_STANDARD =>
      val r = PROMOTING_TO_STANDARD
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ram.model.ResourceShareFeatureSet {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet =
      software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED_FROM_POLICY
      extends zio.aws.ram.model.ResourceShareFeatureSet {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet =
      software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.CREATED_FROM_POLICY
  }
  case object PROMOTING_TO_STANDARD
      extends zio.aws.ram.model.ResourceShareFeatureSet {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet =
      software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.PROMOTING_TO_STANDARD
  }
  case object STANDARD extends zio.aws.ram.model.ResourceShareFeatureSet {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet =
      software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet.STANDARD
  }
}
