package zio.aws.ram.model
import zio.aws.ram.model.primitives.DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ResourceShareInvitation(
    resourceShareInvitationArn: Optional[String] = Optional.Absent,
    resourceShareName: Optional[String] = Optional.Absent,
    resourceShareArn: Optional[String] = Optional.Absent,
    senderAccountId: Optional[String] = Optional.Absent,
    receiverAccountId: Optional[String] = Optional.Absent,
    invitationTimestamp: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.ram.model.ResourceShareInvitationStatus] =
      Optional.Absent,
    resourceShareAssociations: Optional[
      Iterable[zio.aws.ram.model.ResourceShareAssociation]
    ] = Optional.Absent,
    receiverArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ResourceShareInvitation = {
    import ResourceShareInvitation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ResourceShareInvitation
      .builder()
      .optionallyWith(
        resourceShareInvitationArn.map(value => value: java.lang.String)
      )(_.resourceShareInvitationArn)
      .optionallyWith(resourceShareName.map(value => value: java.lang.String))(
        _.resourceShareName
      )
      .optionallyWith(resourceShareArn.map(value => value: java.lang.String))(
        _.resourceShareArn
      )
      .optionallyWith(senderAccountId.map(value => value: java.lang.String))(
        _.senderAccountId
      )
      .optionallyWith(receiverAccountId.map(value => value: java.lang.String))(
        _.receiverAccountId
      )
      .optionallyWith(
        invitationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.invitationTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        resourceShareAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceShareAssociations)
      .optionallyWith(receiverArn.map(value => value: java.lang.String))(
        _.receiverArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ResourceShareInvitation.ReadOnly =
    zio.aws.ram.model.ResourceShareInvitation.wrap(buildAwsValue())
}
object ResourceShareInvitation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ResourceShareInvitation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ResourceShareInvitation =
      zio.aws.ram.model.ResourceShareInvitation(
        resourceShareInvitationArn.map(value => value),
        resourceShareName.map(value => value),
        resourceShareArn.map(value => value),
        senderAccountId.map(value => value),
        receiverAccountId.map(value => value),
        invitationTimestamp.map(value => value),
        status.map(value => value),
        resourceShareAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        receiverArn.map(value => value)
      )
    def resourceShareInvitationArn: Optional[String]
    def resourceShareName: Optional[String]
    def resourceShareArn: Optional[String]
    def senderAccountId: Optional[String]
    def receiverAccountId: Optional[String]
    def invitationTimestamp: Optional[DateTime]
    def status: Optional[zio.aws.ram.model.ResourceShareInvitationStatus]
    def resourceShareAssociations
        : Optional[List[zio.aws.ram.model.ResourceShareAssociation.ReadOnly]]
    def receiverArn: Optional[String]
    def getResourceShareInvitationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "resourceShareInvitationArn",
        resourceShareInvitationArn
      )
    def getResourceShareName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceShareName", resourceShareName)
    def getResourceShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceShareArn", resourceShareArn)
    def getSenderAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("senderAccountId", senderAccountId)
    def getReceiverAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("receiverAccountId", receiverAccountId)
    def getInvitationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("invitationTimestamp", invitationTimestamp)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShareInvitationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResourceShareAssociations: ZIO[Any, AwsError, List[
      zio.aws.ram.model.ResourceShareAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceShareAssociations",
      resourceShareAssociations
    )
    def getReceiverArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("receiverArn", receiverArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ResourceShareInvitation
  ) extends zio.aws.ram.model.ResourceShareInvitation.ReadOnly {
    override val resourceShareInvitationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareInvitationArn())
        .map(value => value: String)
    override val resourceShareName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceShareName())
      .map(value => value: String)
    override val resourceShareArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceShareArn())
      .map(value => value: String)
    override val senderAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.senderAccountId())
      .map(value => value: String)
    override val receiverAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.receiverAccountId())
      .map(value => value: String)
    override val invitationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.invitationTimestamp())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val status
        : Optional[zio.aws.ram.model.ResourceShareInvitationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.ram.model.ResourceShareInvitationStatus.wrap(value)
        )
    override val resourceShareAssociations
        : Optional[List[zio.aws.ram.model.ResourceShareAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.ResourceShareAssociation.wrap(item)
          }.toList
        )
    override val receiverArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.receiverArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ResourceShareInvitation
  ): zio.aws.ram.model.ResourceShareInvitation.ReadOnly = new Wrapper(impl)
}
