package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceShareInvitationStatus {
  def unwrap
      : software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus
}
object ResourceShareInvitationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus
  ): zio.aws.ram.model.ResourceShareInvitationStatus = value match {
    case software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.ACCEPTED =>
      val r = ACCEPTED
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ram.model.ResourceShareInvitationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.ram.model.ResourceShareInvitationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.PENDING
  }
  case object ACCEPTED extends zio.aws.ram.model.ResourceShareInvitationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.ACCEPTED
  }
  case object REJECTED extends zio.aws.ram.model.ResourceShareInvitationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.REJECTED
  }
  case object EXPIRED extends zio.aws.ram.model.ResourceShareInvitationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus.EXPIRED
  }
}
