package zio.aws.ram.model
import zio.aws.ram.model.primitives.DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ResourceSharePermissionDetail(
    arn: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    defaultVersion: Optional[Boolean] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent,
    permission: Optional[String] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    lastUpdatedTime: Optional[DateTime] = Optional.Absent,
    isResourceTypeDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ResourceSharePermissionDetail = {
    import ResourceSharePermissionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ResourceSharePermissionDetail
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(defaultVersion.map(value => value: java.lang.Boolean))(
        _.defaultVersion
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(permission.map(value => value: java.lang.String))(
        _.permission
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        isResourceTypeDefault.map(value => value: java.lang.Boolean)
      )(_.isResourceTypeDefault)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ResourceSharePermissionDetail.ReadOnly =
    zio.aws.ram.model.ResourceSharePermissionDetail.wrap(buildAwsValue())
}
object ResourceSharePermissionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ResourceSharePermissionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ResourceSharePermissionDetail =
      zio.aws.ram.model.ResourceSharePermissionDetail(
        arn.map(value => value),
        version.map(value => value),
        defaultVersion.map(value => value),
        name.map(value => value),
        resourceType.map(value => value),
        permission.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        isResourceTypeDefault.map(value => value)
      )
    def arn: Optional[String]
    def version: Optional[String]
    def defaultVersion: Optional[Boolean]
    def name: Optional[String]
    def resourceType: Optional[String]
    def permission: Optional[String]
    def creationTime: Optional[DateTime]
    def lastUpdatedTime: Optional[DateTime]
    def isResourceTypeDefault: Optional[Boolean]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getPermission: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("permission", permission)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getIsResourceTypeDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isResourceTypeDefault", isResourceTypeDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ResourceSharePermissionDetail
  ) extends zio.aws.ram.model.ResourceSharePermissionDetail.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val defaultVersion: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultVersion())
      .map(value => value: Boolean)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val permission: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.permission())
      .map(value => value: String)
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val lastUpdatedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.ram.model.primitives.DateTime(value))
    override val isResourceTypeDefault: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isResourceTypeDefault())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ResourceSharePermissionDetail
  ): zio.aws.ram.model.ResourceSharePermissionDetail.ReadOnly = new Wrapper(
    impl
  )
}
