package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceShareStatus {
  def unwrap: software.amazon.awssdk.services.ram.model.ResourceShareStatus
}
object ResourceShareStatus {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceShareStatus
  ): zio.aws.ram.model.ResourceShareStatus = value match {
    case software.amazon.awssdk.services.ram.model.ResourceShareStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.ram.model.ResourceShareStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ram.model.ResourceShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.ram.model.ResourceShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareStatus.PENDING
  }
  case object ACTIVE extends zio.aws.ram.model.ResourceShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareStatus.ACTIVE
  }
  case object FAILED extends zio.aws.ram.model.ResourceShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareStatus.FAILED
  }
  case object DELETING extends zio.aws.ram.model.ResourceShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareStatus.DELETING
  }
  case object DELETED extends zio.aws.ram.model.ResourceShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceShareStatus =
      software.amazon.awssdk.services.ram.model.ResourceShareStatus.DELETED
  }
}
