package zio.aws.ram.model
import scala.jdk.CollectionConverters._
sealed trait ResourceStatus {
  def unwrap: software.amazon.awssdk.services.ram.model.ResourceStatus
}
object ResourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.ram.model.ResourceStatus
  ): zio.aws.ram.model.ResourceStatus = value match {
    case software.amazon.awssdk.services.ram.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ram.model.ResourceStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.ram.model.ResourceStatus.ZONAL_RESOURCE_INACCESSIBLE =>
      val r = ZONAL_RESOURCE_INACCESSIBLE
      r
    case software.amazon.awssdk.services.ram.model.ResourceStatus.LIMIT_EXCEEDED =>
      val r = LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.ram.model.ResourceStatus.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
    case software.amazon.awssdk.services.ram.model.ResourceStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.ram.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceStatus =
      software.amazon.awssdk.services.ram.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.ram.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceStatus =
      software.amazon.awssdk.services.ram.model.ResourceStatus.AVAILABLE
  }
  case object ZONAL_RESOURCE_INACCESSIBLE
      extends zio.aws.ram.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceStatus =
      software.amazon.awssdk.services.ram.model.ResourceStatus.ZONAL_RESOURCE_INACCESSIBLE
  }
  case object LIMIT_EXCEEDED extends zio.aws.ram.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceStatus =
      software.amazon.awssdk.services.ram.model.ResourceStatus.LIMIT_EXCEEDED
  }
  case object UNAVAILABLE extends zio.aws.ram.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceStatus =
      software.amazon.awssdk.services.ram.model.ResourceStatus.UNAVAILABLE
  }
  case object PENDING extends zio.aws.ram.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ram.model.ResourceStatus =
      software.amazon.awssdk.services.ram.model.ResourceStatus.PENDING
  }
}
