package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceNameAndResourceType(
    resourceType: Optional[String] = Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    resourceRegionScope: Optional[zio.aws.ram.model.ResourceRegionScope] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ServiceNameAndResourceType = {
    import ServiceNameAndResourceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ServiceNameAndResourceType
      .builder()
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(resourceRegionScope.map(value => value.unwrap))(
        _.resourceRegionScope
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.ServiceNameAndResourceType.ReadOnly =
    zio.aws.ram.model.ServiceNameAndResourceType.wrap(buildAwsValue())
}
object ServiceNameAndResourceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ServiceNameAndResourceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ServiceNameAndResourceType =
      zio.aws.ram.model.ServiceNameAndResourceType(
        resourceType.map(value => value),
        serviceName.map(value => value),
        resourceRegionScope.map(value => value)
      )
    def resourceType: Optional[String]
    def serviceName: Optional[String]
    def resourceRegionScope: Optional[zio.aws.ram.model.ResourceRegionScope]
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getResourceRegionScope
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceRegionScope] =
      AwsError.unwrapOptionField("resourceRegionScope", resourceRegionScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ServiceNameAndResourceType
  ) extends zio.aws.ram.model.ServiceNameAndResourceType.ReadOnly {
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val resourceRegionScope
        : Optional[zio.aws.ram.model.ResourceRegionScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRegionScope())
        .map(value => zio.aws.ram.model.ResourceRegionScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ServiceNameAndResourceType
  ): zio.aws.ram.model.ServiceNameAndResourceType.ReadOnly = new Wrapper(impl)
}
