package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ram.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class TagFilter(
    tagKey: Optional[TagKey] = Optional.Absent,
    tagValues: Optional[Iterable[TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ram.model.TagFilter = {
    import TagFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.TagFilter
      .builder()
      .optionallyWith(
        tagKey.map(value => TagKey.unwrap(value): java.lang.String)
      )(_.tagKey)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            TagValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.TagFilter.ReadOnly =
    zio.aws.ram.model.TagFilter.wrap(buildAwsValue())
}
object TagFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ram.model.TagFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.TagFilter = zio.aws.ram.model
      .TagFilter(tagKey.map(value => value), tagValues.map(value => value))
    def tagKey: Optional[TagKey]
    def tagValues: Optional[List[TagValue]]
    def getTagKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("tagKey", tagKey)
    def getTagValues: ZIO[Any, AwsError, List[TagValue]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.TagFilter
  ) extends zio.aws.ram.model.TagFilter.ReadOnly {
    override val tagKey: Optional[TagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.tagKey())
      .map(value => zio.aws.ram.model.primitives.TagKey(value))
    override val tagValues: Optional[List[TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ram.model.primitives.TagValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.TagFilter
  ): zio.aws.ram.model.TagFilter.ReadOnly = new Wrapper(impl)
}
