package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceShareArn: String,
    tags: Iterable[zio.aws.ram.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.TagResourceRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.TagResourceRequest.ReadOnly =
    zio.aws.ram.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.TagResourceRequest =
      zio.aws.ram.model.TagResourceRequest(
        resourceShareArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceShareArn: String
    def tags: List[zio.aws.ram.model.Tag.ReadOnly]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.ram.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.TagResourceRequest
  ) extends zio.aws.ram.model.TagResourceRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val tags: List[zio.aws.ram.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.ram.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.TagResourceRequest
  ): zio.aws.ram.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
