package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ram.model.primitives.TagKey
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceShareArn: String,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.UntagResourceRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.UntagResourceRequest.ReadOnly =
    zio.aws.ram.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.UntagResourceRequest =
      zio.aws.ram.model.UntagResourceRequest(resourceShareArn, tagKeys)
    def resourceShareArn: String
    def tagKeys: List[TagKey]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.UntagResourceRequest
  ) extends zio.aws.ram.model.UntagResourceRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.ram.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.UntagResourceRequest
  ): zio.aws.ram.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
