package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResourceShareRequest(
    resourceShareArn: String,
    name: Optional[String] = Optional.Absent,
    allowExternalPrincipals: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest = {
    import UpdateResourceShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        allowExternalPrincipals.map(value => value: java.lang.Boolean)
      )(_.allowExternalPrincipals)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.UpdateResourceShareRequest.ReadOnly =
    zio.aws.ram.model.UpdateResourceShareRequest.wrap(buildAwsValue())
}
object UpdateResourceShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.UpdateResourceShareRequest =
      zio.aws.ram.model.UpdateResourceShareRequest(
        resourceShareArn,
        name.map(value => value),
        allowExternalPrincipals.map(value => value),
        clientToken.map(value => value)
      )
    def resourceShareArn: String
    def name: Optional[String]
    def allowExternalPrincipals: Optional[Boolean]
    def clientToken: Optional[String]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getAllowExternalPrincipals: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowExternalPrincipals", allowExternalPrincipals)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest
  ) extends zio.aws.ram.model.UpdateResourceShareRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val allowExternalPrincipals: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowExternalPrincipals())
        .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest
  ): zio.aws.ram.model.UpdateResourceShareRequest.ReadOnly = new Wrapper(impl)
}
