package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResourceShareResponse(
    resourceShare: Optional[zio.aws.ram.model.ResourceShare] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse = {
    import UpdateResourceShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse
      .builder()
      .optionallyWith(resourceShare.map(value => value.buildAwsValue()))(
        _.resourceShare
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly =
    zio.aws.ram.model.UpdateResourceShareResponse.wrap(buildAwsValue())
}
object UpdateResourceShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.UpdateResourceShareResponse =
      zio.aws.ram.model.UpdateResourceShareResponse(
        resourceShare.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def resourceShare: Optional[zio.aws.ram.model.ResourceShare.ReadOnly]
    def clientToken: Optional[String]
    def getResourceShare
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShare.ReadOnly] =
      AwsError.unwrapOptionField("resourceShare", resourceShare)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse
  ) extends zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly {
    override val resourceShare
        : Optional[zio.aws.ram.model.ResourceShare.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShare())
        .map(value => zio.aws.ram.model.ResourceShare.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse
  ): zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly = new Wrapper(impl)
}
