package zio.aws.ram
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.ram.model.primitives.Policy.Type
import zio.aws.ram.model.primitives.{TagValue, TagKey, Policy}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.ram.model.primitives.DateTime.Type
    type Integer = Int
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.ram.model.primitives.MaxResults.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.ram.model.primitives.Policy.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.ram.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.ram.model.primitives.TagValue.Type
  }
  type PermissionArnList = List[String]
  type PolicyList = List[Policy]
  type PrincipalArnOrIdList = List[String]
  type PrincipalList = List[zio.aws.ram.model.Principal]
  type ResourceArnList = List[String]
  type ResourceList = List[zio.aws.ram.model.Resource]
  type ResourceShareArnList = List[String]
  type ResourceShareAssociationList =
    List[zio.aws.ram.model.ResourceShareAssociation]
  type ResourceShareInvitationArnList = List[String]
  type ResourceShareInvitationList =
    List[zio.aws.ram.model.ResourceShareInvitation]
  type ResourceShareList = List[zio.aws.ram.model.ResourceShare]
  type ResourceSharePermissionList =
    List[zio.aws.ram.model.ResourceSharePermissionSummary]
  type ServiceNameAndResourceTypeList =
    List[zio.aws.ram.model.ServiceNameAndResourceType]
  type TagFilters = List[zio.aws.ram.model.TagFilter]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.ram.model.Tag]
  type TagValueList = List[TagValue]
}
