package zio.aws.rbin
import zio.aws.rbin.model.{
  ListRulesRequest,
  GetRuleRequest,
  ListTagsForResourceRequest,
  CreateRuleRequest,
  DeleteRuleRequest,
  UntagResourceRequest,
  UpdateRuleRequest,
  TagResourceRequest
}
import zio.aws.rbin.model.CreateRuleResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.rbin.{
  RbinAsyncClientBuilder,
  RbinAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.rbin.model.{
  ListRulesResponse,
  UpdateRuleResponse,
  GetRuleResponse,
  RuleSummary,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateRuleResponse,
  TagResourceResponse,
  DeleteRuleResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Rbin extends AspectSupport[Rbin] {
  val api: RbinAsyncClient
  def deleteRule(
      request: DeleteRuleRequest
  ): IO[AwsError, zio.aws.rbin.model.DeleteRuleResponse.ReadOnly]
  def updateRule(
      request: UpdateRuleRequest
  ): IO[AwsError, zio.aws.rbin.model.UpdateRuleResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.rbin.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.rbin.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.rbin.model.TagResourceResponse.ReadOnly]
  def listRules(
      request: ListRulesRequest
  ): ZStream[Any, AwsError, zio.aws.rbin.model.RuleSummary.ReadOnly]
  def listRulesPaginated(
      request: ListRulesRequest
  ): IO[AwsError, zio.aws.rbin.model.ListRulesResponse.ReadOnly]
  def getRule(
      request: GetRuleRequest
  ): IO[AwsError, zio.aws.rbin.model.GetRuleResponse.ReadOnly]
  def createRule(request: CreateRuleRequest): IO[AwsError, ReadOnly]
}
object Rbin {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Rbin] = customized(identity)
  def customized(
      customization: RbinAsyncClientBuilder => RbinAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Rbin] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RbinAsyncClientBuilder => RbinAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Rbin] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RbinAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[RbinAsyncClient, RbinAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[RbinAsyncClient, RbinAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new RbinImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class RbinImpl[R](
      override val api: RbinAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Rbin
      with AwsServiceBase[R] {
    override val serviceName: String = "Rbin"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RbinImpl[R1] = new RbinImpl(api, newAspect, r)
    def deleteRule(
        request: DeleteRuleRequest
    ): IO[AwsError, zio.aws.rbin.model.DeleteRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.DeleteRuleRequest,
        DeleteRuleResponse
      ]("deleteRule", api.deleteRule)(request.buildAwsValue())
        .map(zio.aws.rbin.model.DeleteRuleResponse.wrap)
        .provideEnvironment(r)
    def updateRule(
        request: UpdateRuleRequest
    ): IO[AwsError, zio.aws.rbin.model.UpdateRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.UpdateRuleRequest,
        UpdateRuleResponse
      ]("updateRule", api.updateRule)(request.buildAwsValue())
        .map(zio.aws.rbin.model.UpdateRuleResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.rbin.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.rbin.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.rbin.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.rbin.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.rbin.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.rbin.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listRules(
        request: ListRulesRequest
    ): ZStream[Any, AwsError, zio.aws.rbin.model.RuleSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.rbin.model.ListRulesRequest,
        ListRulesResponse,
        RuleSummary
      ](
        "listRules",
        api.listRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.rules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.rbin.model.RuleSummary.wrap(item))
        .provideEnvironment(r)
    def listRulesPaginated(
        request: ListRulesRequest
    ): IO[AwsError, zio.aws.rbin.model.ListRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.ListRulesRequest,
        ListRulesResponse
      ]("listRules", api.listRules)(request.buildAwsValue())
        .map(zio.aws.rbin.model.ListRulesResponse.wrap)
        .provideEnvironment(r)
    def getRule(
        request: GetRuleRequest
    ): IO[AwsError, zio.aws.rbin.model.GetRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.GetRuleRequest,
        GetRuleResponse
      ]("getRule", api.getRule)(request.buildAwsValue())
        .map(zio.aws.rbin.model.GetRuleResponse.wrap)
        .provideEnvironment(r)
    def createRule(request: CreateRuleRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rbin.model.CreateRuleRequest,
        CreateRuleResponse
      ]("createRule", api.createRule)(request.buildAwsValue())
        .map(zio.aws.rbin.model.CreateRuleResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteRule(request: DeleteRuleRequest): ZIO[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.DeleteRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRule(request))
  def updateRule(request: UpdateRuleRequest): ZIO[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.UpdateRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRule(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listRules(request: ListRulesRequest): ZStream[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.RuleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRules(request))
  def listRulesPaginated(request: ListRulesRequest): ZIO[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.ListRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRulesPaginated(request))
  def getRule(request: GetRuleRequest): ZIO[
    zio.aws.rbin.Rbin,
    AwsError,
    zio.aws.rbin.model.GetRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRule(request))
  def createRule(
      request: CreateRuleRequest
  ): ZIO[zio.aws.rbin.Rbin, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createRule(request))
}
