package zio.aws.rbin
import zio.aws.rbin.model.{
  ListRulesRequest,
  GetRuleRequest,
  ListTagsForResourceRequest,
  CreateRuleRequest,
  DeleteRuleRequest,
  UntagResourceRequest,
  UpdateRuleRequest,
  TagResourceRequest
}
import zio.aws.rbin.model.CreateRuleResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.rbin.RbinAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object RbinMock extends Mock[Rbin] {
  object DeleteRule
      extends Effect[
        DeleteRuleRequest,
        AwsError,
        zio.aws.rbin.model.DeleteRuleResponse.ReadOnly
      ]
  object UpdateRule
      extends Effect[
        UpdateRuleRequest,
        AwsError,
        zio.aws.rbin.model.UpdateRuleResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.rbin.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.rbin.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.rbin.model.TagResourceResponse.ReadOnly
      ]
  object ListRules
      extends Stream[
        ListRulesRequest,
        AwsError,
        zio.aws.rbin.model.RuleSummary.ReadOnly
      ]
  object ListRulesPaginated
      extends Effect[
        ListRulesRequest,
        AwsError,
        zio.aws.rbin.model.ListRulesResponse.ReadOnly
      ]
  object GetRule
      extends Effect[
        GetRuleRequest,
        AwsError,
        zio.aws.rbin.model.GetRuleResponse.ReadOnly
      ]
  object CreateRule extends Effect[CreateRuleRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, Rbin] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Rbin] { rts =>
        zio.ZIO.succeed {
          new Rbin {
            val api: RbinAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Rbin = this
            def deleteRule(
                request: DeleteRuleRequest
            ): IO[AwsError, zio.aws.rbin.model.DeleteRuleResponse.ReadOnly] =
              proxy(DeleteRule, request)
            def updateRule(
                request: UpdateRuleRequest
            ): IO[AwsError, zio.aws.rbin.model.UpdateRuleResponse.ReadOnly] =
              proxy(UpdateRule, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.rbin.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.rbin.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.rbin.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def listRules(
                request: ListRulesRequest
            ): ZStream[Any, AwsError, zio.aws.rbin.model.RuleSummary.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListRules, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listRulesPaginated(
                request: ListRulesRequest
            ): IO[AwsError, zio.aws.rbin.model.ListRulesResponse.ReadOnly] =
              proxy(ListRulesPaginated, request)
            def getRule(
                request: GetRuleRequest
            ): IO[AwsError, zio.aws.rbin.model.GetRuleResponse.ReadOnly] =
              proxy(GetRule, request)
            def createRule(request: CreateRuleRequest): IO[AwsError, ReadOnly] =
              proxy(CreateRule, request)
          }
        }
      }
    }
  }
}
