package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.Description
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRuleRequest(
    retentionPeriod: zio.aws.rbin.model.RetentionPeriod,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rbin.model.Tag]] = Optional.Absent,
    resourceType: zio.aws.rbin.model.ResourceType,
    resourceTags: Optional[Iterable[zio.aws.rbin.model.ResourceTag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.CreateRuleRequest = {
    import CreateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.CreateRuleRequest
      .builder()
      .retentionPeriod(retentionPeriod.buildAwsValue())
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.CreateRuleRequest.ReadOnly =
    zio.aws.rbin.model.CreateRuleRequest.wrap(buildAwsValue())
}
object CreateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.CreateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.CreateRuleRequest =
      zio.aws.rbin.model.CreateRuleRequest(
        retentionPeriod.asEditable,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType,
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def retentionPeriod: zio.aws.rbin.model.RetentionPeriod.ReadOnly
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.rbin.model.Tag.ReadOnly]]
    def resourceType: zio.aws.rbin.model.ResourceType
    def resourceTags: Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]]
    def getRetentionPeriod
        : ZIO[Any, Nothing, zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      ZIO.succeed(retentionPeriod)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rbin.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceType: ZIO[Any, Nothing, zio.aws.rbin.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.CreateRuleRequest
  ) extends zio.aws.rbin.model.CreateRuleRequest.ReadOnly {
    override val retentionPeriod: zio.aws.rbin.model.RetentionPeriod.ReadOnly =
      zio.aws.rbin.model.RetentionPeriod.wrap(impl.retentionPeriod())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.rbin.model.primitives.Description(value))
    override val tags: Optional[List[zio.aws.rbin.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.Tag.wrap(item)
          }.toList
        )
    override val resourceType: zio.aws.rbin.model.ResourceType =
      zio.aws.rbin.model.ResourceType.wrap(impl.resourceType())
    override val resourceTags
        : Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.ResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.CreateRuleRequest
  ): zio.aws.rbin.model.CreateRuleRequest.ReadOnly = new Wrapper(impl)
}
