package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.{Description, RuleIdentifier}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRuleResponse(
    identifier: Optional[RuleIdentifier] = Optional.Absent,
    retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rbin.model.Tag]] = Optional.Absent,
    resourceType: Optional[zio.aws.rbin.model.ResourceType] = Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.rbin.model.ResourceTag]] =
      Optional.Absent,
    status: Optional[zio.aws.rbin.model.RuleStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.CreateRuleResponse = {
    import CreateRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.CreateRuleResponse
      .builder()
      .optionallyWith(
        identifier.map(value => RuleIdentifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.CreateRuleResponse.ReadOnly =
    zio.aws.rbin.model.CreateRuleResponse.wrap(buildAwsValue())
}
object CreateRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.CreateRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.CreateRuleResponse =
      zio.aws.rbin.model.CreateRuleResponse(
        identifier.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value => value),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value)
      )
    def identifier: Optional[RuleIdentifier]
    def retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly]
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.rbin.model.Tag.ReadOnly]]
    def resourceType: Optional[zio.aws.rbin.model.ResourceType]
    def resourceTags: Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]]
    def status: Optional[zio.aws.rbin.model.RuleStatus]
    def getIdentifier: ZIO[Any, AwsError, RuleIdentifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getRetentionPeriod
        : ZIO[Any, AwsError, zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rbin.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceType: ZIO[Any, AwsError, zio.aws.rbin.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getStatus: ZIO[Any, AwsError, zio.aws.rbin.model.RuleStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.CreateRuleResponse
  ) extends zio.aws.rbin.model.CreateRuleResponse.ReadOnly {
    override val identifier: Optional[RuleIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.rbin.model.primitives.RuleIdentifier(value))
    override val retentionPeriod
        : Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.rbin.model.RetentionPeriod.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.rbin.model.primitives.Description(value))
    override val tags: Optional[List[zio.aws.rbin.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.Tag.wrap(item)
          }.toList
        )
    override val resourceType: Optional[zio.aws.rbin.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.rbin.model.ResourceType.wrap(value))
    override val resourceTags
        : Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.ResourceTag.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.rbin.model.RuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rbin.model.RuleStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.CreateRuleResponse
  ): zio.aws.rbin.model.CreateRuleResponse.ReadOnly = new Wrapper(impl)
}
