package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.RuleIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRuleRequest(identifier: RuleIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.DeleteRuleRequest = {
    import DeleteRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.DeleteRuleRequest
      .builder()
      .identifier(RuleIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.DeleteRuleRequest.ReadOnly =
    zio.aws.rbin.model.DeleteRuleRequest.wrap(buildAwsValue())
}
object DeleteRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.DeleteRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.DeleteRuleRequest =
      zio.aws.rbin.model.DeleteRuleRequest(identifier)
    def identifier: RuleIdentifier
    def getIdentifier: ZIO[Any, Nothing, RuleIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.DeleteRuleRequest
  ) extends zio.aws.rbin.model.DeleteRuleRequest.ReadOnly {
    override val identifier: RuleIdentifier =
      zio.aws.rbin.model.primitives.RuleIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.DeleteRuleRequest
  ): zio.aws.rbin.model.DeleteRuleRequest.ReadOnly = new Wrapper(impl)
}
