package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.RuleIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRuleRequest(identifier: RuleIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.GetRuleRequest = {
    import GetRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.GetRuleRequest
      .builder()
      .identifier(RuleIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.GetRuleRequest.ReadOnly =
    zio.aws.rbin.model.GetRuleRequest.wrap(buildAwsValue())
}
object GetRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.GetRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.GetRuleRequest =
      zio.aws.rbin.model.GetRuleRequest(identifier)
    def identifier: RuleIdentifier
    def getIdentifier: ZIO[Any, Nothing, RuleIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.GetRuleRequest
  ) extends zio.aws.rbin.model.GetRuleRequest.ReadOnly {
    override val identifier: RuleIdentifier =
      zio.aws.rbin.model.primitives.RuleIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.GetRuleRequest
  ): zio.aws.rbin.model.GetRuleRequest.ReadOnly = new Wrapper(impl)
}
