package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.{Description, RuleIdentifier}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRuleResponse(
    identifier: Optional[RuleIdentifier] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    resourceType: Optional[zio.aws.rbin.model.ResourceType] = Optional.Absent,
    retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod] =
      Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.rbin.model.ResourceTag]] =
      Optional.Absent,
    status: Optional[zio.aws.rbin.model.RuleStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.GetRuleResponse = {
    import GetRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.GetRuleResponse
      .builder()
      .optionallyWith(
        identifier.map(value => RuleIdentifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.GetRuleResponse.ReadOnly =
    zio.aws.rbin.model.GetRuleResponse.wrap(buildAwsValue())
}
object GetRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.GetRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.GetRuleResponse =
      zio.aws.rbin.model.GetRuleResponse(
        identifier.map(value => value),
        description.map(value => value),
        resourceType.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value)
      )
    def identifier: Optional[RuleIdentifier]
    def description: Optional[Description]
    def resourceType: Optional[zio.aws.rbin.model.ResourceType]
    def retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly]
    def resourceTags: Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]]
    def status: Optional[zio.aws.rbin.model.RuleStatus]
    def getIdentifier: ZIO[Any, AwsError, RuleIdentifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getResourceType: ZIO[Any, AwsError, zio.aws.rbin.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getRetentionPeriod
        : ZIO[Any, AwsError, zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getStatus: ZIO[Any, AwsError, zio.aws.rbin.model.RuleStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.GetRuleResponse
  ) extends zio.aws.rbin.model.GetRuleResponse.ReadOnly {
    override val identifier: Optional[RuleIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.rbin.model.primitives.RuleIdentifier(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.rbin.model.primitives.Description(value))
    override val resourceType: Optional[zio.aws.rbin.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.rbin.model.ResourceType.wrap(value))
    override val retentionPeriod
        : Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.rbin.model.RetentionPeriod.wrap(value))
    override val resourceTags
        : Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.ResourceTag.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.rbin.model.RuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rbin.model.RuleStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.GetRuleResponse
  ): zio.aws.rbin.model.GetRuleResponse.ReadOnly = new Wrapper(impl)
}
