package zio.aws.rbin.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.rbin.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRulesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    resourceType: zio.aws.rbin.model.ResourceType,
    resourceTags: Optional[Iterable[zio.aws.rbin.model.ResourceTag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.ListRulesRequest = {
    import ListRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.ListRulesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.ListRulesRequest.ReadOnly =
    zio.aws.rbin.model.ListRulesRequest.wrap(buildAwsValue())
}
object ListRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.ListRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.ListRulesRequest =
      zio.aws.rbin.model.ListRulesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceType,
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def resourceType: zio.aws.rbin.model.ResourceType
    def resourceTags: Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceType: ZIO[Any, Nothing, zio.aws.rbin.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.ListRulesRequest
  ) extends zio.aws.rbin.model.ListRulesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rbin.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rbin.model.primitives.NextToken(value))
    override val resourceType: zio.aws.rbin.model.ResourceType =
      zio.aws.rbin.model.ResourceType.wrap(impl.resourceType())
    override val resourceTags
        : Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.ResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.ListRulesRequest
  ): zio.aws.rbin.model.ListRulesRequest.ReadOnly = new Wrapper(impl)
}
