package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRulesResponse(
    rules: Optional[Iterable[zio.aws.rbin.model.RuleSummary]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.ListRulesResponse = {
    import ListRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.ListRulesResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.ListRulesResponse.ReadOnly =
    zio.aws.rbin.model.ListRulesResponse.wrap(buildAwsValue())
}
object ListRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.ListRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.ListRulesResponse =
      zio.aws.rbin.model.ListRulesResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def rules: Optional[List[zio.aws.rbin.model.RuleSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.rbin.model.RuleSummary.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.ListRulesResponse
  ) extends zio.aws.rbin.model.ListRulesResponse.ReadOnly {
    override val rules
        : Optional[List[zio.aws.rbin.model.RuleSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.RuleSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rbin.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.ListRulesResponse
  ): zio.aws.rbin.model.ListRulesResponse.ReadOnly = new Wrapper(impl)
}
