package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.RuleArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: RuleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(RuleArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.rbin.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.ListTagsForResourceRequest =
      zio.aws.rbin.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: RuleArn
    def getResourceArn: ZIO[Any, Nothing, RuleArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.ListTagsForResourceRequest
  ) extends zio.aws.rbin.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: RuleArn =
      zio.aws.rbin.model.primitives.RuleArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.ListTagsForResourceRequest
  ): zio.aws.rbin.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
