package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.{ResourceTagValue, ResourceTagKey}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceTag(
    resourceTagKey: ResourceTagKey,
    resourceTagValue: Optional[ResourceTagValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.ResourceTag = {
    import ResourceTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.ResourceTag
      .builder()
      .resourceTagKey(ResourceTagKey.unwrap(resourceTagKey): java.lang.String)
      .optionallyWith(
        resourceTagValue.map(value =>
          ResourceTagValue.unwrap(value): java.lang.String
        )
      )(_.resourceTagValue)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.ResourceTag.ReadOnly =
    zio.aws.rbin.model.ResourceTag.wrap(buildAwsValue())
}
object ResourceTag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rbin.model.ResourceTag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.ResourceTag = zio.aws.rbin.model
      .ResourceTag(resourceTagKey, resourceTagValue.map(value => value))
    def resourceTagKey: ResourceTagKey
    def resourceTagValue: Optional[ResourceTagValue]
    def getResourceTagKey: ZIO[Any, Nothing, ResourceTagKey] =
      ZIO.succeed(resourceTagKey)
    def getResourceTagValue: ZIO[Any, AwsError, ResourceTagValue] =
      AwsError.unwrapOptionField("resourceTagValue", resourceTagValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.ResourceTag
  ) extends zio.aws.rbin.model.ResourceTag.ReadOnly {
    override val resourceTagKey: ResourceTagKey =
      zio.aws.rbin.model.primitives.ResourceTagKey(impl.resourceTagKey())
    override val resourceTagValue: Optional[ResourceTagValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTagValue())
        .map(value => zio.aws.rbin.model.primitives.ResourceTagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.ResourceTag
  ): zio.aws.rbin.model.ResourceTag.ReadOnly = new Wrapper(impl)
}
