package zio.aws.rbin.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.rbin.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.rbin.model.ResourceType
  ): zio.aws.rbin.model.ResourceType = value match {
    case software.amazon.awssdk.services.rbin.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rbin.model.ResourceType.EBS_SNAPSHOT =>
      val r = EBS_SNAPSHOT
      r
    case software.amazon.awssdk.services.rbin.model.ResourceType.EC2_IMAGE =>
      val r = EC2_IMAGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.rbin.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.rbin.model.ResourceType =
      software.amazon.awssdk.services.rbin.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object EBS_SNAPSHOT extends zio.aws.rbin.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.rbin.model.ResourceType =
      software.amazon.awssdk.services.rbin.model.ResourceType.EBS_SNAPSHOT
  }
  case object EC2_IMAGE extends zio.aws.rbin.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.rbin.model.ResourceType =
      software.amazon.awssdk.services.rbin.model.ResourceType.EC2_IMAGE
  }
}
