package zio.aws.rbin.model
import java.lang.Integer
import zio.ZIO
import zio.aws.rbin.model.primitives.RetentionPeriodValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RetentionPeriod(
    retentionPeriodValue: RetentionPeriodValue,
    retentionPeriodUnit: zio.aws.rbin.model.RetentionPeriodUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.RetentionPeriod = {
    import RetentionPeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.RetentionPeriod
      .builder()
      .retentionPeriodValue(
        RetentionPeriodValue.unwrap(retentionPeriodValue): Integer
      )
      .retentionPeriodUnit(retentionPeriodUnit.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.RetentionPeriod.ReadOnly =
    zio.aws.rbin.model.RetentionPeriod.wrap(buildAwsValue())
}
object RetentionPeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.RetentionPeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.RetentionPeriod = zio.aws.rbin.model
      .RetentionPeriod(retentionPeriodValue, retentionPeriodUnit)
    def retentionPeriodValue: RetentionPeriodValue
    def retentionPeriodUnit: zio.aws.rbin.model.RetentionPeriodUnit
    def getRetentionPeriodValue: ZIO[Any, Nothing, RetentionPeriodValue] =
      ZIO.succeed(retentionPeriodValue)
    def getRetentionPeriodUnit
        : ZIO[Any, Nothing, zio.aws.rbin.model.RetentionPeriodUnit] =
      ZIO.succeed(retentionPeriodUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.RetentionPeriod
  ) extends zio.aws.rbin.model.RetentionPeriod.ReadOnly {
    override val retentionPeriodValue: RetentionPeriodValue =
      zio.aws.rbin.model.primitives
        .RetentionPeriodValue(impl.retentionPeriodValue())
    override val retentionPeriodUnit: zio.aws.rbin.model.RetentionPeriodUnit =
      zio.aws.rbin.model.RetentionPeriodUnit.wrap(impl.retentionPeriodUnit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.RetentionPeriod
  ): zio.aws.rbin.model.RetentionPeriod.ReadOnly = new Wrapper(impl)
}
