package zio.aws.rbin.model
import scala.jdk.CollectionConverters.*
sealed trait RetentionPeriodUnit {
  def unwrap: software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit
}
object RetentionPeriodUnit {
  def wrap(
      value: software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit
  ): zio.aws.rbin.model.RetentionPeriodUnit = value match {
    case software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit.DAYS =>
      val r = DAYS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rbin.model.RetentionPeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit =
      software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object DAYS extends zio.aws.rbin.model.RetentionPeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit =
      software.amazon.awssdk.services.rbin.model.RetentionPeriodUnit.DAYS
  }
}
