package zio.aws.rbin.model
import scala.jdk.CollectionConverters.*
sealed trait RuleStatus {
  def unwrap: software.amazon.awssdk.services.rbin.model.RuleStatus
}
object RuleStatus {
  def wrap(
      value: software.amazon.awssdk.services.rbin.model.RuleStatus
  ): zio.aws.rbin.model.RuleStatus = value match {
    case software.amazon.awssdk.services.rbin.model.RuleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rbin.model.RuleStatus.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.rbin.model.RuleStatus.AVAILABLE =>
      val r = available
      r
  }
  case object unknownToSdkVersion extends zio.aws.rbin.model.RuleStatus {
    override def unwrap: software.amazon.awssdk.services.rbin.model.RuleStatus =
      software.amazon.awssdk.services.rbin.model.RuleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.rbin.model.RuleStatus {
    override def unwrap: software.amazon.awssdk.services.rbin.model.RuleStatus =
      software.amazon.awssdk.services.rbin.model.RuleStatus.PENDING
  }
  case object available extends zio.aws.rbin.model.RuleStatus {
    override def unwrap: software.amazon.awssdk.services.rbin.model.RuleStatus =
      software.amazon.awssdk.services.rbin.model.RuleStatus.AVAILABLE
  }
}
