package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.{Description, RuleIdentifier}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleSummary(
    identifier: Optional[RuleIdentifier] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.RuleSummary = {
    import RuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.RuleSummary
      .builder()
      .optionallyWith(
        identifier.map(value => RuleIdentifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.RuleSummary.ReadOnly =
    zio.aws.rbin.model.RuleSummary.wrap(buildAwsValue())
}
object RuleSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rbin.model.RuleSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.RuleSummary =
      zio.aws.rbin.model.RuleSummary(
        identifier.map(value => value),
        description.map(value => value),
        retentionPeriod.map(value => value.asEditable)
      )
    def identifier: Optional[RuleIdentifier]
    def description: Optional[Description]
    def retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly]
    def getIdentifier: ZIO[Any, AwsError, RuleIdentifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRetentionPeriod
        : ZIO[Any, AwsError, zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.RuleSummary
  ) extends zio.aws.rbin.model.RuleSummary.ReadOnly {
    override val identifier: Optional[RuleIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.rbin.model.primitives.RuleIdentifier(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.rbin.model.primitives.Description(value))
    override val retentionPeriod
        : Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.rbin.model.RetentionPeriod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.RuleSummary
  ): zio.aws.rbin.model.RuleSummary.ReadOnly = new Wrapper(impl)
}
