package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.RuleArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: RuleArn,
    tags: Iterable[zio.aws.rbin.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.TagResourceRequest
      .builder()
      .resourceArn(RuleArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.TagResourceRequest.ReadOnly =
    zio.aws.rbin.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.TagResourceRequest =
      zio.aws.rbin.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: RuleArn
    def tags: List[zio.aws.rbin.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, RuleArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.rbin.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.TagResourceRequest
  ) extends zio.aws.rbin.model.TagResourceRequest.ReadOnly {
    override val resourceArn: RuleArn =
      zio.aws.rbin.model.primitives.RuleArn(impl.resourceArn())
    override val tags: List[zio.aws.rbin.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.rbin.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.TagResourceRequest
  ): zio.aws.rbin.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
