package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.{TagKey, RuleArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: RuleArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.UntagResourceRequest
      .builder()
      .resourceArn(RuleArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.UntagResourceRequest.ReadOnly =
    zio.aws.rbin.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.UntagResourceRequest =
      zio.aws.rbin.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: RuleArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, RuleArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.UntagResourceRequest
  ) extends zio.aws.rbin.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: RuleArn =
      zio.aws.rbin.model.primitives.RuleArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.rbin.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.UntagResourceRequest
  ): zio.aws.rbin.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
